const puppeteer = require("puppeteer");
const fs = require("fs");//para escribir archivos

(async () => {
const browser = await puppeteer.launch({
  headless: false, // 🔧 lo muestra con ventana real
  defaultViewport: null, // pantalla completa
  args: ["--start-maximized"]
});
  const page = await browser.newPage();

  // Ir a la URL del cine
    //Cinemex: https://cinemex.com/cine/30/galerias/fecha-20250410
    //Cinepolis menos exacto: https://cinepolis.com/mx?cinema=cinepolis-patio-acapulco
await page.goto("https://cinemex.com/cine/30/galerias/fecha-20250410", {
  waitUntil: "networkidle2",
  timeout: 0 // 🔧 sin límite de tiempo
});

console.log("Esperando el HTML completo...");
const html = await page.content();
//console.log(html);
fs.writeFileSync("html_last_fetch.html", html, "utf-8");
console.log("✅ HTML guardado en html_last_fetch.html");
    
await page.waitForSelector("#movies-list-content", { timeout: 10000 }); // 🔧 espera hasta X segundos


  // Extraer info
  const movies = await page.evaluate(() => {
    const container = document.querySelector("#movies-list-content"); //Aqui dependiendo la página traes un selector u otro...
    const data = [];

    if (!container) return [];

    container.querySelectorAll(":scope > div").forEach(div => {
      const id = div.getAttribute("data-id");
      const img = div.querySelector(".MoviePoster_mf-locations-MoviePoster__dxWCf img");
      const src = img ? img.getAttribute("src") : "";
      data.push({ id, img: src });
    });

    return data;
  });

  console.log(movies);
  await browser.close();
})();
